* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* Figure 7

use "$mainpath/Figures/Figures_data/Figure7.dta", clear

twoway ///
(rarea plota_u plota_d  Years,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line plota_b_level Years, lcolor(blue) lpattern(solid) lwidth(thick)) ///
(line Zero Years, lcolor(black)), legend(off) ///
ytitle("Percent", size(medsmall)) xtitle("Years since shock", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white)) name(part1, replace) nodraw

twoway ///
(rarea plotb_u plotb_d  Years,  ///
fcolor(gs13) lcolor(gs13) lw(none) lpattern(solid)) ///
(line plotb_b_level Years, lcolor(blue) lpattern(solid) lwidth(thick)) ///
(line Zero Years, lcolor(black)), legend(off) ///
ytitle("Percent", size(medsmall)) xtitle("Years since shock", size(medsmall)) ///
graphregion(color(white)) plotregion(color(white)) name(part2, replace) nodraw

graph combine part1 part2, ycommon   






